<?php /* var_dump($permission); */ ?>
<?php (empty($permission) ? redirect(base_url("error404")) : ""); ?>
<?php if (!empty($this->app->is_can($permission, "view"))) { /* Can View */ ?>
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
    <!-- Toastr -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/toastr/toastr.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/datatables-bs4/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/datatables-responsive/css/responsive.bootstrap4.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/datatables-buttons/css/buttons.bootstrap4.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/datatables-rowreorder/css/rowReorder.bootstrap4.min.css">
    <!-- Bootstrap-Switch  & Plugins -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>vendor/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css">

    <style>
        .btn-xs {
            height: 22px;
            padding: 2px 5px;
            font-size: 12px;
            line-height: 1.5;
            /* If Placeholder of the input is moved up, rem/modify this. */
            border-radius: 3px;
        }

        .table td,
        .table th {

            font-size: 13px;
        }

        th.dt-center,
        td.dt-center {
            width: 5px;
            text-align: center;
        }

        th.dt-active,
        td.dt-active {
            width: 15px;
            text-align: center;
        }

        .profile-pic,
        .profile-pic-list {
            max-width: 80px;
            max-height: 80px;
            display: block;
        }

        .file-upload {
            display: none;
        }

        .circle {
            border-radius: 1000px !important;
            overflow: hidden;
            border: 1px solid #c3c9ca;
            top: 72px;
            max-width: 80px;
            max-height: 80px;
        }

        .circle:hover {
            background-color: #909090;
            cursor: pointer
        }

        img {
            max-width: 100%;
            height: auto;
        }

        .p-image {
            margin-left: 65px;
            margin-top: -20px;
            color: #666666;
            transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
        }

        .p-image:hover {
            transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
        }

        .upload-button {
            font-size: 1.2em;
        }

        .upload-button:hover {
            transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
            color: #999;
        }
    </style>
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->

    <div class="col-12 pt-3">
        <div class="text-right">
            <?php if ($this->app->is_can($permission, "add")) { ?>
                <a id="addBtn" class="btn btn-primary btn-xs mb-2" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#addModal" href="javascript:void(0);"><span><i class="fa fa-plus"></i></span></a>
            <?php } ?>
        </div>
        <div class="table-responsive m-t-40">
            <table id="mTable" class="table table-bordered table-striped table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th class="IsNotSort text-center">รูป</th>
                        <th>บริษัท/สาขา</th>
                        <th>ชื่อผู้ใช้</th>
                        <th>ชื่อ-นามสกุล</th>
                        <th>ฝ่าย</th>
                        <th>ตำแหน่ง</th>
                        <th>ระดับ</th>
                        <th>กลุ่ม</th>
                        <th class="IsActive IsNotSort text-center"><i class="fa fa-eye"></i></th>
                        <?php if ($this->app->is_can($permission, "edit")) { ?>
                            <th class="IsNotSort text-center"><i class="fas fa-edit"></i></th>
                            <th class="IsNotSort text-center"><i class="fas fa-key"></i></th>
                        <?php } ?>
                        <?php if ($this->app->is_can($permission, "delete")) { ?>
                            <th class="IsNotSort text-center"><i class="fas fa-trash-alt"></i></th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
    <div class="modal fade" id="userPicModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img id="user_pic" src="">
                </div>
                <div class="modal-footer">
                    <button type="reset" class="btn btn-xs btn-default" data-dismiss="modal">ปิด</button>
                </div>
            </div>
        </div>
    </div>
    <!-- /.modal -->

    <?php if ($this->app->is_can($permission, "add")) { ?>
        <div class="modal fade" id="addModal" tabindex="-1" role="dialog">
            <form id="addForm" method="post" action="<?php echo base_url('sys/user/add'); ?>" enctype="multipart/form-data">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">เพิ่ม</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <div class="circle upload-button" data-id="user_pic_add">
                                            <!-- User Profile Image -->
                                            <img class="profile-pic" src="" style="min-height: 80px;max-height: 80px;">

                                            <!-- Default Image -->
                                            <!-- <i class="fa fa-user fa-5x"></i> -->
                                        </div>
                                        <div class="p-image">
                                            <i class="fa fa-camera upload-button"></i>
                                            <input class="file-upload" type="file" name="user_pic" id="user_pic_add" accept="image/*" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="company_id" class="form-control" required>
                                            <?php
                                            $sql = "SELECT * FROM company WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกบริษัท</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->company_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="branch_id" class="form-control select-form branch_id" required>
                                            <?php
                                            $sql = "SELECT * FROM branch WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกสาขา</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->branch_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-3">
                                    <div class="form-group">
                                        <select name="title_id" class="form-control select-form title_id" required>
                                            <?php
                                            $sql = "SELECT * FROM title WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกคำนำหน้า</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->title_name; ?> | <?php echo $item->gender_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-9">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="user_fullname" placeholder="ชื่อ - นามสกุล" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="manage_id" class="form-control select-form manage_id" required>
                                            <?php
                                            $sql = "SELECT * FROM manage WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกกลุ่มจัดการ</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->manage_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="level" class="form-control select-form" required>
                                            <option value="">เลือกระดับ</option>
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            <option value="5">5</option>
                                            <option value="6">6</option>
                                            <option value="7">7</option>
                                            <option value="8">8</option>
                                            <option value="9">9</option>
                                            <option value="10">10</option>
                                            <option value="11">11</option>
                                            <option value="12">12</option>
                                            <option value="13">13</option>
                                            <option value="14">14</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="division_id" id="division_id" class="form-control select-form division_id" required>
                                            <?php
                                            $sql = "SELECT * FROM division WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกฝ่าย</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->division_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="section_id" id="section_id" class="form-control select-form section_id">
                                            <?php
                                            $sql = "SELECT * FROM section WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกแผนก</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option data-id="<?php echo $item->division_id; ?>" value="<?php echo $item->id; ?>"><?php echo $item->section_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="position_id" id="position_id" class="form-control select-form" required>
                                            <?php
                                            $sql = "SELECT * FROM position WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกตำแหน่ง</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->position_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="group_id" id="group_id" class="form-control select-form" required>
                                            <?php
                                            $sql = "SELECT * FROM sys_group WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกกลุ่มผู้ใช้งาน</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->group_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="email" class="form-control form-control-user" id="user_email" name="email" placeholder="อีเมลพนักงาน" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control form-control-user" id="user_name" name="user_name" placeholder="ชื่อผู้ใช้งาน" minlength="4" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 mb-3 mb-sm-0">
                                    <div class="form-group">
                                        <input type="password" class="form-control form-control-user" id="user_password" name="user_password" placeholder="Password" minlength="4" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="password" class="form-control form-control-user" id="confirm_user_password" name="confirm_user_password" placeholder="Confirm Password">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="reset" class="btn btn-xs btn-default" data-dismiss="modal">ยกเลิก</button>
                            <button type="submit" class="btn btn-xs btn-primary">บันทึก</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal -->
    <?php } ?>

    <?php if ($this->app->is_can($permission, "edit")) { ?>
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog">
            <form id="editForm" method="post" action="<?php echo base_url('sys/user/edit'); ?>" enctype="multipart/form-data">
                <input type="hidden" name="id">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">แก้ไข</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>

                        <div class="modal-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <div class="circle upload-button" data-id="user_pic_add">
                                            <!-- User Profile Image -->
                                            <img class="profile-pic" src="" style="min-height: 80px;max-height: 80px;">

                                            <!-- Default Image -->
                                            <!-- <i class="fa fa-user fa-5x"></i> -->
                                        </div>
                                        <div class="p-image">
                                            <i class="fa fa-camera upload-button"></i>
                                            <input class="file-upload" type="file" name="user_pic" id="edit_user_pic_add" accept="image/*" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="company_id" class="form-control" required>
                                            <?php
                                            $sql = "SELECT * FROM company WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกบริษัท</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->company_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="branch_id" class="form-control select-form branch_id" required>
                                            <?php
                                            $sql = "SELECT * FROM branch WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกสาขา</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->branch_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-3">
                                    <div class="form-group">
                                        <select name="title_id" class="form-control select-form title_id" required>
                                            <?php
                                            $sql = "SELECT * FROM title WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกคำนำหน้า</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->title_name; ?> | <?php echo $item->gender_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-9">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="user_fullname" placeholder="ชื่อ - นามสกุล" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="manage_id" class="form-control select-form manage_id" required>
                                            <?php
                                            $sql = "SELECT * FROM manage WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกกลุ่มจัดการ</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->manage_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="level" class="form-control select-form" required>
                                            <option value="">เลือกระดับ</option>
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            <option value="5">5</option>
                                            <option value="6">6</option>
                                            <option value="7">7</option>
                                            <option value="8">8</option>
                                            <option value="9">9</option>
                                            <option value="10">10</option>
                                            <option value="11">11</option>
                                            <option value="12">12</option>
                                            <option value="13">13</option>
                                            <option value="14">14</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="division_id" id="edit_division_id" class="form-control select-form division_id" required>
                                            <?php
                                            $sql = "SELECT * FROM division WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกฝ่าย</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->division_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="section_id" id="edit_section_id" class="form-control select-form section_id">
                                            <?php
                                            $sql = "SELECT * FROM section WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกแผนก</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option data-id="<?php echo $item->division_id; ?>" value="<?php echo $item->id; ?>"><?php echo $item->section_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="position_id" id="edit_position_id" class="form-control select-form" required>
                                            <?php
                                            $sql = "SELECT * FROM position WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกตำแหน่ง</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->position_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <select name="group_id" id="edit_group_id" class="form-control select-form" required>
                                            <?php
                                            $sql = "SELECT * FROM sys_group WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                                            ?>
                                            <option value="">เลือกกลุ่มผู้ใช้งาน</option>
                                            <?php
                                            foreach ($this->db->query($sql)->result() as $item) {
                                            ?>
                                                <option value="<?php echo $item->id; ?>"><?php echo $item->group_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="email" class="form-control form-control-user" id="edit_user_email" name="email" placeholder="อีเมลพนักงาน" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control form-control-user" id="edit_user_name" name="user_name" placeholder="ชื่อผู้ใช้งาน" minlength="4" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 mb-3 mb-sm-0">
                                    <div class="form-group">
                                        <input type="password" class="form-control form-control-user" id="edit_user_password" name="user_password" placeholder="Password">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="password" class="form-control form-control-user" id="edit_confirm_user_password" name="edit_confirm_user_password" placeholder="Confirm Password">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="reset" class="btn btn-xs btn-default" data-dismiss="modal">ยกเลิก</button>
                            <button type="submit" class="btn btn-xs btn-primary">บันทึก</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal -->
    <?php } ?>

    <!-- jQuery -->
    <script src="<?php echo base_url(); ?>vendor/jquery/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo base_url(); ?>vendor/jquery-ui/jquery-ui.min.js"></script>
    <!-- SweetAlert2 -->
    <script src="<?php echo base_url(); ?>vendor/sweetalert2/sweetalert2.min.js"></script>
    <!-- DataTables  & Plugins -->
    <script src="<?php echo base_url(); ?>vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-rowreorder/js/dataTables.rowReorder.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables-rowreorder/js/rowReorder.bootstrap4.min.js"></script>
    <!-- Bootstrap-Switch  & Plugins -->
    <script src="<?php echo base_url(); ?>vendor/bootstrap-switch/js/bootstrap-switch.min.js"></script>
    <!-- jquery-validation -->
    <script src="<?php echo base_url(); ?>vendor/jquery-validation/jquery.validate.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/jquery-validation/additional-methods.min.js"></script>
    <!-- Toastr -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

    <script type="text/javascript">
        var timestamp = '<?php echo $timestamp; ?>';
        var mTable;
        ! function(window, document, $) {
            "use strict";
            mTable = $('#mTable').DataTable({
                "colReorder": {
                    "realtime": true
                },
                "orderable": false,
                "autoWidth": false,
                "pageLength": 10,
                "processing": true,
                "stateSave": true,
                stateSaveCallback: function(settings, data) {
                    localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
                },
                stateLoadCallback: function(settings) {
                    return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
                },
                "language": {
                    "url": "<?php echo base_url() ?>plugins/datatables/th.json",
                    "headers": {
                        "Access-Control-Allow-Origin": "*"
                    },
                    searchPlaceholder: "<?php echo strip_tags(@$var->txt_search); ?>",
                },
                "ajax": "<?php echo base_url('sys/user/ajax_list'); ?>",
                "deferRender": true,
                "aLengthMenu": [
                    [10, 25, 50, 100],
                    [10, 25, 50, 100]
                ],
                "columns": [{
                        "data": {
                            "id": "id",
                            "user_pic": "user_pic"
                        },
                        render: function(data, type) {
                            return '<a href="#" class="userPicBtn" data-id="' + data.id + '" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#userPicModal">' + data.user_pic + '</a>';
                        }
                    }, {
                        "data": "company_name"
                    },
                    {
                        "data": "user_name"
                    },
                    {
                        "data": {
                            "title_name": "title_name",
                            "user_fullname": "user_fullname"
                        },
                        render: function(data, type) {
                            return data.title_name + data.user_fullname;
                        }
                    },
                    {
                        "data": {
                            "division_name": "division_name",
                            "section_name": "section_name"
                        },
                        render: function(data, type) {
                            return data.division_name + '(' + data.section_name + ')';
                        }
                    },
                    {
                        "data": "position_name"
                    },
                    {
                        "data": "level"
                    },
                    {
                        "data": "group_name"
                    },
                    {
                        "data": {
                            "id": "id",
                            "is_active": "is_active",
                            "created_by": "created_by"
                        },
                        render: function(data, type) {
                            if (data.created_by == 'system') {
                                return '<input data-id="' + data.id + '" data-active="' + data.is_active + '" type="checkbox" class="switch" <?php echo ($this->app->is_can($permission, "edit") ? '' : 'disabled'); ?> ' + (data.is_active == 1 ? 'checked' : '') + ' data-size="mini" data-on-color="success" data-off-color="warning" data-on-text="Yes" data-off-text="No"  disabled />';
                            } else {
                                return '<input data-id="' + data.id + '" data-active="' + data.is_active + '" type="checkbox" class="switch" <?php echo ($this->app->is_can($permission, "edit") ? '' : 'disabled'); ?> ' + (data.is_active == 1 ? 'checked' : '') + ' data-size="mini" data-on-color="success" data-off-color="warning" data-on-text="Yes" data-off-text="No"/>';
                            }
                        }
                    },
                    <?php if ($this->app->is_can($permission, "edit")) { ?> {
                            "data": {
                                "id": "id"
                            },
                            render: function(data, type) {
                                return '<button type="button" class="btn btn-info btn-xs" id="editBtn" data-id="' + data.id + '" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#editModal"><i class="fas fa-pencil-alt"></i></button>';
                            }
                        },
                        {
                            "data": {
                                "id": "id",
                                "created_by": "created_by"
                            },
                            render: function(data, type) {
                                if (data.created_by == 'system') {
                                    return '<button type="button" class="btn btn-default btn-xs" title="Reset password" disabled><i class="fas fa-redo"></i></button>';
                                } else {
                                    return '<button type="button" class="btn btn-warning btn-xs confirmResetPassword" data-href="<?php echo base_url('sys/user/resetPassword/'); ?>' + data.id + '"><i class="fas fa-redo"></i></button>';
                                }
                            }
                        },
                    <?php } ?>
                    <?php if ($this->app->is_can($permission, "delete")) { ?> {
                            "data": {
                                "id": "id",
                                "created_by": "created_by"
                            },
                            render: function(data, type) {
                                if (data.created_by == 'system') {
                                    return '<button type="button" class="btn btn-default btn-xs" title="Delete" disabled><i class="fas fa-trash-alt"></i></button>';
                                } else {
                                    return '<button type="button" class="btn btn-danger btn-xs confirmDelete" data-href="<?php echo base_url('sys/user/delete/'); ?>' + data.id + '"><i class="fas fa-trash-alt"></i></button>';
                                }
                            }
                        },
                    <?php } ?>
                ],
                "columnDefs": [{
                        targets: '_all'
                    },
                    {
                        "width": "5px",
                        "targets": 0
                    },
                    {
                        "className": "dt-active",
                        "targets": "IsActive"
                    },
                    {
                        "orderable": false,
                        "className": "dt-center",
                        "targets": "IsNotSort"
                    }
                ],
                "fnDrawCallback": function() {
                    $(".switch[type='checkbox']").bootstrapSwitch();
                    $('.switch[type="checkbox"]').on('switchChange.bootstrapSwitch', function(event, state) {
                        $(location).attr('href', '<?php echo base_url() ?>sys/user/change_active/' + $(this).data('id') + '.' + $(this).data('active'));
                    });
                },
                "createdRow": function(row, data, rowIndex) {
                    // Per-cell function to do whatever needed with cells
                    $.each($('td', row), function(colIndex) {
                        // console.log(data)
                        $(this).attr('title', data.user_name.trim() + '=>' + data.user_fullname);
                    });
                }
            });


            function reloadTable() {
                mTable.ajax.reload();
            }

            setInterval(function() {
                $.post('<?php echo base_url('sys/user/timestamp'); ?>',
                    function(data) {
                        if (timestamp != data) {
                            timestamp = data;
                            reloadTable();
                        }
                    });

            }, 12340);

        }(window, document, jQuery);
        $(document).ready(function() {

            $('#mTable tbody').on('click', 'tr td .userPicBtn', function() {
                $('#user_pic').attr("src", $('*[data-pic="' + $(this).data('id') + '"]').attr('src'));
            });

            <?php if ($this->app->is_can($permission, "add")) { ?>
                $('#addBtn').click(function() {
                    $('#addForm').trigger("reset");
                    var $form = $('#addForm');
                    $('.profile-pic').attr("src", "");
                    $form.find('.is-invalid,.is-valid').css('border-color', '').removeClass('is-invalid').removeClass('is-valid');
                    $form.find('.error.invalid-feedback').html('');
                    $form.find('[name="section_id"] option').hide();
                });
            <?php } ?>

            <?php if ($this->app->is_can($permission, "edit")) { ?>
                $('#mTable tbody').on('click', 'tr td #editBtn', function() {
                    var $form = $('#editForm');
                    $form.find('.is-invalid,.is-valid').css('border-color', '').removeClass('is-invalid').removeClass('is-valid');
                    $form.find('.error.invalid-feedback').html('');
                    $('.profile-pic').attr("src", "");
                    $.post("<?php echo base_url('sys/user/ajax_data'); ?>", {
                            id: $(this).data('id')
                        },
                        function(data) {
                            $form.find('[name="id"]').val(data['id']);
                            $form.find('.profile-pic').attr('src', data['user_pic']);
                            $form.find('[name="level"]').val(data['level']);
                            $form.find('[name="user_name"]').val(data['user_name']);
                            $form.find('[name="user_fullname"]').val(data['user_fullname']);
                            $form.find('[name="title_id"]').val(data['title_id']);
                            $form.find('[name="user_fullname"]').val(data['user_fullname']);
                            $form.find('[name="title_id"]').val(data['title_id']).trigger('change');
                            $form.find('[name="branch_id"]').val(data['branch_id']).trigger('change');
                            $form.find('[name="manage_id"]').val(data['manage_id']).trigger('change');
                            $form.find('[name="company_id"]').val(data['company_id']).trigger('change');
                            $form.find('[name="section_id"]').val(data['section_id']).trigger('change');
                            $form.find('[name="division_id"]').val(data['division_id']).trigger('change');
                            $form.find('[name="position_id"]').val(data['position_id']).trigger('change');
                            $form.find('[name="group_id"]').val(data['group_id']).trigger('change');
                            $form.find('[name="email"]').val(data['email']);
                            $form.find('[name="section_id"] option').hide();
                            $form.find('[name="section_id"] [data-id="' + data['division_id'] + '"]').show();
                        }, "json");
                });
            <?php } ?>

        });

        var readURL = function(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('.profile-pic').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }


        $(".file-upload").on('change', function() {
            readURL(this);
        });

        $(".upload-button").on('click', function() {
            $("#" + $(this).data('id')).click();
            console.log($(this).data('id'));
        });

        $('#addForm').validate({
            rules: {
                user_name: {
                    required: true,
                    remote: {
                        url: "<?php echo base_url(); ?>sys/user/ajax_user_data",
                        type: "post"
                    }
                },
                confirm_user_password: {
                    equalTo: "#user_password"
                }
            },
            messages: {},
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
        $('#editForm').validate({
            rules: {
                user_name: {
                    required: true
                },
                edit_confirm_user_password: {
                    equalTo: "#edit_user_password"
                }
            },
            messages: {},
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        /* Conform delete data in table */
        $('#mTable tbody').on('click', '.confirmDelete', function() {
            Swal.fire({
                title: 'คุณต้องการลบรายการนี้หรือไม่?',
                width: 300,
                showDenyButton: false,
                showCancelButton: true,
                confirmButtonText: 'ตกลง',
                confirmButtonColor: '#dc3545',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    location.href = $(this).data('href');
                }
            })
        });

        /* Conform reset password in table */
        $('#mTable tbody').on('click', '.confirmResetPassword', function() {
            Swal.fire({
                title: 'คุณต้องการรีเซ็ตรหัสผ่านหรือไม่?',
                width: 300,
                showDenyButton: false,
                showCancelButton: true,
                confirmButtonText: 'ตกลง',
                confirmButtonColor: '#dc3545',
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    location.href = $(this).data('href');
                }
            })
        });

        $(function() {
            $('.section_id option').hide();
            $('.section_id option[data-id="' + $('.division_id').val() + '"]').show();
        });
        $('.division_id').change(function() {
            $('.section_id option').hide();
            $('.section_id option[data-id="' + $(this).val() + '"]').show();
        });
    </script>
<?php
} /* Can View */ ?>