  <?php
  // var_dump($this->session->userdata("user_profile")); 
  ?>
  <style>
    .profile-pic {
      max-width: 120px;
      max-height: 120px;
      display: block;
    }

    .file-upload {
      display: none;
    }

    .circle {
      border-radius: 1000px !important;
      overflow: hidden;
      width: 128px;
      height: 128px;
      border: 8px solid #c3c9ca;
      top: 72px;
    }

    .circle:hover {
      background-color: #909090;
      cursor: pointer
    }

    img {
      max-width: 100%;
      height: auto;
    }

    .p-image {
      margin-left: -25px;
      margin-top: 90;
      top: 167px;
      right: 30px;
      color: #666666;
      transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
    }

    .p-image:hover {
      transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
    }

    .upload-button {
      font-size: 1.2em;
    }

    .upload-button:hover {
      transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
      color: #999;
    }
  </style>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row mt-3">
        <div class="col-md-5">
          <!-- Profile Image -->
          <div class="card card-primary card-outline" style="border-top: 0.25rem solid #4e73df !important;">
            <div class="card-body">

              <h4 class="profile-username text-center">
                <?php echo $this->session->userdata("user_profile")->user_fullname; ?>
              </h4>
              <p class="text-muted text-center"><?php echo $this->session->userdata("user_profile")->company_name; ?></p>
              <p class="text-small text-muted text-center">(<?php echo $this->session->userdata("user_profile")->branch_name; ?>)</p>
              <ul class="list-group list-group-unbordered mb-3">
                <li class="list-group-item">
                  <b>ชื่อผู้ใช้งาน</b> <a class="float-right"><?php echo $this->session->userdata("user_profile")->user_name; ?></a>
                </li>
                <li class="list-group-item">
                  <b>ตำแหน่ง</b> <a class="float-right"><?php echo $this->session->userdata("user_profile")->position_name; ?></a>
                </li>
                <li class="list-group-item">
                  <b>ฝ่าย</b> <a class="float-right"><?php echo $this->session->userdata("user_profile")->division_name; ?>(<?php echo $this->session->userdata("user_profile")->section_name; ?>)</a>
                </li>
                <li class="list-group-item">
                  <b>กลุ่มผู้ใช้</b> <a class="float-right"><?php echo $this->session->userdata("user_profile")->group_name; ?></a>
                </li>
              </ul>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
          <form method="POST" action="<?php echo base_url(); ?>main/change_password">
            <div class="card card-primary card-outline mt-3" style="border-top: 0.25rem solid #4e73df !important;">
              <div class="card-body">
                <h4 class="profile-username text-center">
                  เปลี่ยนรหัสผ่านผู้ใช้
                </h4>
                <ul class="list-group list-group-unbordered mb-3">
                  <li class="list-group-item">
                    <input type="password" class="form-control" id="user_password" name="user_password" placeholder="รหัสผ่านใหม่" required>
                  </li>
                  <li class="list-group-item">
                    <input type="password" class="form-control" id="confirm_user_password" placeholder="ยืนยันรหัสผ่านใหม่" required>
                  </li>
                </ul>
                <div class="form-group row">
                  <button type="submit" class="btn btn-block btn-primary">เปลี่ยนรหัสผ่าน</button>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
          </form>
          <!-- /.card -->

        </div>
        <!-- /.col -->
        <div class="col-md-7">
          <div class="card card-primary card-outline" style="border-top: 0.25rem solid #4e73df !important;">
            <div class="card-body">
              <div class="tab-content">
                <div class="tab-pane active" id="settings">
                  <form class="form-horizontal" method="post" action="<?php echo base_url('main/profile_edit'); ?>" enctype="multipart/form-data">
                    <div class="form-group row">
                      <div class="circle upload-button">
                        <!-- User Profile Image -->
                        <img class="profile-pic" src="<?php echo $this->app->user_pic($this->session->userdata("user_profile")->id); ?>">

                        <!-- Default Image -->
                        <!-- <i class="fa fa-user fa-5x"></i> -->
                      </div>
                      <div class="p-image">
                        <i class="fa fa-camera upload-button"></i>
                        <input class="file-upload" type="file" name="user_pic" accept="image/*" />
                      </div>
                    </div>
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">คำนำหน้า</label>
                      <div class="col-sm-9">
                        <select name="title_id" class="form-control">
                          <option value=""></option>
                          <?php
                          $sql = "SELECT * FROM title WHERE record_status ='N' AND is_active ='1' ORDER BY sort ASC";
                          foreach ($this->db->query($sql)->result() as $item) {
                            echo "<option value='" . $item->id . "' " . ($this->session->userdata("user_profile")->title_id == $item->id ? 'selected' : '') . ">" . $item->title_name . "</option>";
                          }
                          ?>
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">ชื่อ - นามสกุล</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="user_fullname" placeholder="ชื่อ - นามสกุล" value="<?php echo $this->session->userdata("user_profile")->user_fullname; ?>">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">ฝ่าย</label>
                      <div class="col-sm-9">
                        <select name="division_id" class="form-control">
                          <option value=""></option>
                          <?php
                          $sql = "SELECT * FROM division WHERE record_status ='N' AND is_active ='1' ";
                          $sql .= "AND company_id = '" . $this->session->userdata("user_profile")->company_id . "' ";
                          $sql .= "ORDER BY sort ASC";
                          foreach ($this->db->query($sql)->result() as $item) {
                            echo "<option value='" . $item->id . "' " . ($this->session->userdata("user_profile")->division_id == $item->id ? 'selected' : '') . ">" . $item->division_name . "</option>";
                          }
                          ?>
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">แผนก</label>
                      <div class="col-sm-9">
                        <select name="section_id" class="form-control">
                          <option value=""></option>
                          <?php
                          $sql = "SELECT * FROM section WHERE record_status ='N' AND is_active ='1' ";
                          $sql .= "AND company_id = '" . $this->session->userdata("user_profile")->company_id . "' ";
                          $sql .= "ORDER BY sort ASC";
                          foreach ($this->db->query($sql)->result() as $item) {
                            echo "<option data-division_id ='" . $item->division_id . "' value='" . $item->id . "' " . ($this->session->userdata("user_profile")->section_id == $item->id ? 'selected' : '') . ">" . $item->section_name . "</option>";
                          }
                          ?>
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label class="col-sm-3 col-form-label">อีเมล</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="email" placeholder="อีเมล" value="<?php echo $this->session->userdata("user_profile")->email; ?>">
                      </div>
                    </div>
                    <div class="form-group row">
                      <div class="offset-sm-3 col-sm-9">
                        <button type="submit" class="btn btn-block btn-danger">บันทึก</button>
                      </div>
                    </div>
                  </form>
                </div>
                <!-- /.tab-pane -->
              </div>
              <!-- /.tab-content -->
            </div><!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div><!-- /.container-fluid -->
  </section>
  <!-- /.content -->

  <!-- Bootstrap core JavaScript-->
  <script src="<?php echo base_url(); ?>vendor/jquery/jquery.min.js"></script>

  <script>
    $(document).ready(function() {
      var password = document.getElementById("user_password"),
        confirm_password = document.getElementById("confirm_user_password");

      function validatePassword() {
        if (password.value != confirm_password.value) {
          confirm_password.setCustomValidity("Passwords Don't Match");
        } else {
          confirm_password.setCustomValidity('');
        }
      }

      password.onchange = validatePassword;
      confirm_password.onkeyup = validatePassword;

      var readURL = function(input) {
        if (input.files && input.files[0]) {
          var reader = new FileReader();

          reader.onload = function(e) {
            $('.profile-pic').attr('src', e.target.result);
          }

          reader.readAsDataURL(input.files[0]);
        }
      }


      $(".file-upload").on('change', function() {
        readURL(this);
      });

      $(".upload-button").on('click', function() {
        $(".file-upload").click();
      });
    });
  </script>