<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Permission extends CI_Controller
{

    function __construct()
    {
        /* Call the Model constructor */
        parent::__construct();
        /* Get System Variable */
        $this->data['var'] = $this->app->get_var_sys();

        /* Check Authen & Permission User */
        if (empty($this->session->userdata("user_profile")->id)) {
            redirect('authen', 'refresh');
            exit();
        } else {
            /* Get Permission Module */
            $this->data['permission'] = @$this->app->get_permission("sys/group");
            $this->data['timestamp'] = @$this->app->last_updated_table("sys_group");
        }
    }

    public function index()
    {
        $sql = "SELECT * FROM sys_group WHERE  id ='" . $this->uri->segment(3) . "'";
        $this->data['group'] = $this->db->query($sql)->row();
        $this->data['navbar'] = 'layout/navbar';
        $this->data['sidebar'] = 'layout/sidebar';
        $this->data['footer'] = 'layout/footer';
        $this->data['page'] = 'sys/permission';
        $this->load->view("layout/main", $this->data);
    }

    /* Set permission Data */
    public function set()
    {
        /* เริ่ม Transactions */
        $this->db->trans_begin();

        $group_id = $this->input->post('group_id');
        unset($_POST['group_id']);

        /* Clear Group */
        $this->db->where('group_id', $group_id);
        $this->db->delete('sys_permission');

        foreach ($this->input->post() as $key => $input) {
            $is_view = false;
            $data = array();
            $data['group_id'] = $group_id;
            $data['module'] = ($this->app->decrypt_segment($key));
            // echo $data['module'] . "<br>";
            foreach ($this->input->post($key) as $permisson) {
                $is_view = true;
                $data[$permisson] = 1;
                // echo $data[$permisson] . "-";
            }

            if ($is_view) {
                $data['view'] = 1;
            }

            // echo "<hr>";
            // var_dump($data);

            if (!$this->db->insert('sys_permission', $data)) {
                $db_error = $this->db->error();
                $this->session->set_flashdata('type', 'error');
                $this->session->set_flashdata('msg', 'ERROR [CODE] : ' . $db_error['code']);
            } else {
                $this->session->set_flashdata('type', 'success');
                $this->session->set_flashdata('msg', 'Completed');
                $this->app->write_log($this->router->fetch_class() . '-' . $this->router->fetch_method() . '=> ' . $this->session->flashdata('msg'), json_encode($this->db->last_query()));
            }
        }

        /* ถ้ามีการผิดพลาดให้ทำการ Rollback ข้อมูล */
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            /* Create Log Data  */
            $this->app->write_log('error-' . $this->router->fetch_class() . '-' . $this->router->fetch_method() . '=> ' . $this->session->flashdata('msg') . ': ' . $db_error['message'], json_encode($this->db->last_query()));
        } else {
            /* ถ้าไม่มีข้อผิดพลาดให้ยืนยันการทำงาน */
            $this->db->trans_commit();
        }

        redirect($this->agent->referrer());
    }

    /* <!-- ============================================================== -->
      <!-- Function -->
      <!-- ============================================================== --> */
}
