<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title><?php echo @$var->txt_title; ?></title>
  <link rel="icon" href="<?php echo base_url(); ?>img/favicon.png" type="image/png">
  <!-- Custom fonts for this template-->
  <link href="<?php echo base_url(); ?>vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <!-- Custom styles for this template-->
  <link href="<?php echo base_url(); ?>css/sb-admin-2.css" rel="stylesheet">
  <!-- Toastr -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet">

</head>

<body class="bg-gradient-primary">

  <div class="container">

    <!-- Outer Row -->
    <div class="row justify-content-center">

      <div class="col-xl-10 col-lg-12 col-md-9">

        <div class="card o-hidden border-0 shadow-lg my-5">
          <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
              <div class="col-lg-5 d-none d-lg-block bg-login-image"></div>
              <div class="col-lg-7">
                <div class="p-5">
                  <div class="text-center">
                    <h1 class="h4 text-gray-900 mb-4">ลงทะเบียนใช้งาน!</h1>
                  </div>
                  <form action="<?php echo base_url(); ?>authen/create_user" method="post" class="user">
                    <div class="form-group">
                      <div class="form-group row">
                        <div class="col-12">
                          <select name="company_id" class="form-control" required>
                            <?php
                            $sql = "SELECT * FROM company WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                            ?>
                            <option value="">เลือกบริษัท</option>
                            <?php
                            foreach ($this->db->query($sql)->result() as $item) {
                            ?>
                              <option value="<?php echo $item->id; ?>"><?php echo $item->company_name; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="form-group row">
                      <div class="col-12">
                        <input type="text" class="form-control" name="user_fullname" placeholder="ชื่อ - นามสกุล" required>
                      </div>
                    </div>
                    <div class="form-group">
                      <div class="form-group row">
                        <div class="col-12">
                          <select name="division_id" id="division_id" class="form-control select-form" required>
                            <?php
                            $sql = "SELECT * FROM division WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                            ?>
                            <option value="">เลือกฝ่าย</option>
                            <?php
                            foreach ($this->db->query($sql)->result() as $item) {
                            ?>
                              <option value="<?php echo $item->id; ?>"><?php echo $item->division_name; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="form-group">
                      <div class="form-group row">
                        <div class="col-12">
                          <select name="section_id" id="section_id" class="form-control select-form" required>
                            <?php
                            $sql = "SELECT * FROM section WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                            ?>
                            <option value="">เลือกแผนก</option>
                            <?php
                            foreach ($this->db->query($sql)->result() as $item) {
                            ?>
                              <option data-id="<?php echo $item->division_id; ?>" value="<?php echo $item->id; ?>"><?php echo $item->section_name; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="form-group">
                      <div class="form-group row">
                        <div class="col-12">
                          <select name="position_id" id="position_id" class="form-control select-form" required>
                            <?php
                            $sql = "SELECT * FROM position WHERE record_status ='N' AND is_active ='1' ORDER BY sort ";
                            ?>
                            <option value="">เลือกตำแหน่ง</option>
                            <?php
                            foreach ($this->db->query($sql)->result() as $item) {
                            ?>
                              <option value="<?php echo $item->id; ?>"><?php echo $item->position_name; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="form-group">
                      <input type="email" class="form-control form-control-user" id="user_email" name="user_email" placeholder="อีเมลพนักงาน" required>
                    </div>
                    <div class="form-group">
                      <input type="text" class="form-control form-control-user" id="user_name" name="user_name" placeholder="ชื่อผู้ใช้งาน" minlength="4" required>
                    </div>
                    <div class="form-group row">
                      <div class="col-sm-6 mb-3 mb-sm-0">
                        <input type="password" class="form-control form-control-user" id="user_password" name="user_password" placeholder="Password" minlength="4" required>
                      </div>
                      <div class="col-sm-6">
                        <input type="password" class="form-control form-control-user" id="confirm_user_password" placeholder="Confirm Password">
                      </div>
                    </div>

                    <input type="submit" class="btn btn-primary btn-user btn-block" value="ลงทะเบียนใช้งาน">
                  </form>
                  <hr>
                  <div class="text-center">
                    <a class="small" href="<?php echo base_url(); ?>authen"> ลงทะเบียนใช้งานแล้ว? login!</a>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>

    </div>

  </div>

  </div>

  <!-- Bootstrap core JavaScript-->
  <script src="<?php echo base_url(); ?>vendor/jquery/jquery.min.js"></script>
  <script src="<?php echo base_url(); ?>vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

  <!-- Core plugin JavaScript-->
  <script src="<?php echo base_url(); ?>vendor/jquery-easing/jquery.easing.min.js"></script>

  <!-- Custom scripts for all pages-->
  <script src="<?php echo base_url(); ?>js/sb-admin-2.min.js"></script>
  <script>
    $(function() {
      $('#section_id option').hide();
      $('#section_id option[data-id="' + $('#division_id').val() + '"]').show();
    });
    $('#division_id').change(function() {
      $('#section_id option').hide();
      $('#section_id option[data-id="' + $(this).val() + '"]').show();
    });

    $(document).ready(function() {
      var user_email = document.getElementById("user_email"),
        user_name = document.getElementById("user_name"),
        password = document.getElementById("user_password"),
        confirm_password = document.getElementById("confirm_user_password");

      $('#user_email').change(function() {
        $.post("<?php echo base_url('Authen/ajax_email_data'); ?>", {
            user_email: $(this).val()
          },
          function(data) {
            if (data == false) {
              user_email.setCustomValidity("Email is Exist, Please contact to IT!");
            } else {
              user_email.setCustomValidity('');
            }
          }, "json");
      });

      $('#user_name').change(function() {
        $.post("<?php echo base_url('Authen/ajax_user_data'); ?>", {
            user_name: $(this).val()
          },
          function(data) {
            if (data == false) {
              user_name.setCustomValidity("Username is Exist, Please contact to IT!");
            } else {
              user_name.setCustomValidity('');
            }
          }, "json");
      });


      function validatePassword() {
        if (password.value != confirm_password.value) {
          confirm_password.setCustomValidity("Passwords Don't Match");
        } else {
          confirm_password.setCustomValidity('');
        }
      }

      password.onchange = validatePassword;
      confirm_password.onkeyup = validatePassword;

      var readURL = function(input) {
        if (input.files && input.files[0]) {
          var reader = new FileReader();

          reader.onload = function(e) {
            $('.profile-pic').attr('src', e.target.result);
          }

          reader.readAsDataURL(input.files[0]);
        }
      }


      $(".file-upload").on('change', function() {
        readURL(this);
      });

      $(".upload-button").on('click', function() {
        $(".file-upload").click();
      });
    });
  </script>
  <!-- Toastr -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

  <script>
    $(function() {
      <?php if ($this->session->flashdata('type')) { ?>
        toastr.<?php echo $this->session->flashdata('type') ?>('<?php echo $this->session->flashdata('type') ?>', '<?php echo $this->session->flashdata('msg') ?>', "top-right", "#ff6849", "1000");
      <?php } ?>
    });
  </script>

</body>

</html>